BEGIN TRANSACTION;
CREATE TABLE Applicants (id INTEGER PRIMARY KEY,fullName TEXT,emailAddress TEXT,phoneNumber TEXT);
INSERT INTO "Applicants" VALUES(1,'John Doe','john.doe@example.com','123-456-7890');
INSERT INTO "Applicants" VALUES(2,'Jane Smith','jane.smith@example.com','234-567-8901');
INSERT INTO "Applicants" VALUES(3,'Bob Johnson','bob.johnson@example.com','345-678-9012');
INSERT INTO "Applicants" VALUES(4,'Alice Williams','alice.williams@example.com','456-789-0123');
INSERT INTO "Applicants" VALUES(5,'Tom Brown','tom.brown@example.com','567-890-1234');
CREATE TABLE ApplicationStatuses (applicationId INTEGER PRIMARY KEY,applicantId INTEGER,status TEXT,dateApplied DATE,FOREIGN KEY(applicantId)REFERENCES Applicants(id));
INSERT INTO "ApplicationStatuses" VALUES(1,1,'In Review','2022-01-01');
INSERT INTO "ApplicationStatuses" VALUES(2,2,'Rejected','2022-01-02');
INSERT INTO "ApplicationStatuses" VALUES(3,3,'Interview Scheduled','2022-01-03');
INSERT INTO "ApplicationStatuses" VALUES(4,4,'Hired','2022-01-04');
INSERT INTO "ApplicationStatuses" VALUES(5,5,'Waitlisted','2022-01-05');
CREATE TABLE Employers (id INTEGER PRIMARY KEY,companyName TEXT,contactNumber TEXT);
INSERT INTO "Employers" VALUES(1,'ABC Corp','123-456-7890');
INSERT INTO "Employers" VALUES(2,'XYZ Inc','234-567-8901');
INSERT INTO "Employers" VALUES(3,'PQR Ltd','345-678-9012');
INSERT INTO "Employers" VALUES(4,'STU Co','456-789-0123');
INSERT INTO "Employers" VALUES(5,'MNO Corp','567-890-1234');
CREATE TABLE JobTypes (id INTEGER PRIMARY KEY,typeName TEXT);
INSERT INTO "JobTypes" VALUES(1,'Software Engineer');
INSERT INTO "JobTypes" VALUES(2,'Project Manager');
INSERT INTO "JobTypes" VALUES(3,'Data Analyst');
INSERT INTO "JobTypes" VALUES(4,'Product Designer');
INSERT INTO "JobTypes" VALUES(5,'Quality Assurance');
CREATE TABLE "Jobs" (id INTEGER PRIMARY KEY,employerId INTEGER,jobTypeId INTEGER,locationId INTEGER,Offer INTEGER,Job_Post TEXT,FOREIGN KEY(employerId)REFERENCES Employers(id), FOREIGN KEY(jobTypeId)REFERENCES JobTypes(id), FOREIGN KEY(locationId)REFERENCES Locations(id));
INSERT INTO "Jobs" VALUES(1,1,1,1,80000,'We are looking for a Software Engineer with 3+ years experience...');
INSERT INTO "Jobs" VALUES(2,2,2,2,90000,'Experienced Project Managers needed to lead our cross-functional teams...');
INSERT INTO "Jobs" VALUES(3,3,3,3,70000,'Seeking Data Analysts to join our team and help us make data-driven decisions...');
INSERT INTO "Jobs" VALUES(4,4,4,4,60000,'Looking for creative Product Designers to work on our new product line...');
INSERT INTO "Jobs" VALUES(5,5,5,5,50000,'Join our QA team as we expand and improve our software quality...');
CREATE TABLE Locations (id INTEGER PRIMARY KEY,locationName TEXT);
INSERT INTO "Locations" VALUES(1,'New York City');
INSERT INTO "Locations" VALUES(2,'San Francisco');
INSERT INTO "Locations" VALUES(3,'Chicago');
INSERT INTO "Locations" VALUES(4,'Los Angeles');
INSERT INTO "Locations" VALUES(5,'Austin');
COMMIT;
